# LocalGov Waste collection schedule

This module provides an interface for the viewing of waste collection schedules. It consists of a postcode-based property search form, an address selector, and a schedule viewer.

## Features

- Postcode-based property search
- UPRN-based canonical URLs for easy linking to schedules
- Download of calendar in ICS (iCal) format
- Optional download of PDF collection calendar (uploaded, not generated)
- Print-styled calendar
- Plugin support for additional data providers
- Optional public holiday support

Data provider plugins are included in sub-modules for:

- CSV: Import property and collection data from CSV files.
- Whitespace: Integrate with the [Whitespace Waste Management platform](https://whitespacews.com/) via their API.

A very simple example plugin is also provided.

A Webaspx ([Routeware](https://uk.routeware.com/)) plugin is in development.

## Installing

### Installation

You can install this module with the following composer command:

```
composer require drupal/localgov_waste_collection
```

No data providers are installed by default. Install the included CSV provider sub-module ([README](modules/localgov_waste_collection_csv_provider/README.md)) via the Drupal UI or drush:

```
drush en localgov_waste_collection_csv_provider
```

Or the Whitespace sub-module ([README](modules/localgov_waste_collection_whitespace_provider/README.md)) provider:

```
drush en localgov_waste_collection_whitespace_provider
```

Or the example provider sub-module ([README](modules/localgov_waste_collection_example_provider/README.md)):

```
drush en localgov_waste_collection_example_provider
```

Note that a data provider must be installed and configured for the module to operate.

Further details of these modules are in their respective module README.md files and the [Data providers documentation](docs/providers.md).


## Configuration

Install and configure a data provider plugin first.

The base module settings can be found in the Drupal admin UI under:

```
Configuration > Web services > Waste collection > Settings

Path: /admin/config/services/waste-collection/settings
```

Use this form to set the data provider and the base path for the module, and optionally public holiday support.

By default the base path is:

```
/waste-collection-schedule
```

If you prefer to set configuration via settings.php, add these lines to the settings file for your environment, replacing the values as required:

```
$config['localgov_waste_collection.settings']['active_data_provider'] = 'example_data_provider';
$config['localgov_waste_collection.settings']['waste_collection_path'] = '/my-custom-path';
```

### Paths
If the UPRN is known for a property, the schedule can be accessed directly at:
```
{base_path}/view/{uprn}
```
A postcode search returning matching properties can be accessed directly at:
```
{base_path}/find?postcode={postcode}
```

### Public holidays
If public holidays are enabled, the list of public holidays from https://www.gov.uk/bank-holidays.json will be used to detect any routine collection dates that fall on a holiday.

Use the `Ignored holidays` field to exclude any of the gov.uk supplied holidays.

## Issues

If you run into issues using this module, please report them
at: https://www.drupal.org/project/issues/localgov_waste_collection

## Maintainers

This project is currently maintained by:
- Dan Champion https://github.com/danchamp
- Duncan Davidson https://www.drupal.org/u/ded
- Finn Lewis https://github.com/finnlewis

## Funding

The work to build this module and the Whitespace integration were funded by [Dumfries and Galloway Council](https://www.dumfriesandgalloway.gov.uk/)

The CSV and Webaspx integrations were funded by [Westmorland and Furness Council](https://www.westmorlandandfurness.gov.uk/)

