<?php

declare(strict_types=1);

namespace Drupal\localgov_waste_collection\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines boundary_provider annotation object.
 *
 * @see plugin_api
 *
 * @Annotation
 */
class DataProvider extends Plugin {

  /**
   * The plugin ID.
   *
   * @phpstan-ignore-next-line This is allowed in Drupal, but PHPStan complains even though this is valid
   */
  public readonly string $id;

  /**
   * The human-readable name of the plugin.
   *
   * @ingroup plugin_translatable
   *
   * @phpstan-ignore-next-line This is allowed in Drupal, but PHPStan complains even though this is valid
   */
  public readonly string $label;

}
