<?php

declare(strict_types=1);

namespace Drupal\localgov_waste_collection\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * {@inheritdoc}
 */
class AddressSelectForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'localgov_waste_collection_address_select_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, ?array $properties = NULL) {

    $form['#attributes']['class'][] = 'waste-collection-form';

    $form['uprn'] = [
      '#type' => 'select',
      '#empty_option' => $this->t('Select an address'),
      '#required' => TRUE,
      '#title' => $this->t('Select an address'),
      '#weight' => '0',
      '#attributes' => [
        'class' => ['waste-address'],
      ],
      '#options' => $properties,
    ];

    $form['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('View collection days'),
    ];

    if (!$form_state->hasAnyErrors()) {
      $form['status_messages'] = [
        '#type' => 'status_messages',
        '#weight' => -1000,
      ];
      $form['#sorted'] = FALSE;
    }

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateForm(array &$form, FormStateInterface $form_state): void {
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $form_state->setRedirect('localgov_waste_collection.view', ['uprn' => $form_state->getValue('uprn')]);
  }

}
