<?php

declare(strict_types=1);

namespace Drupal\localgov_waste_collection\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\Config\ConfigFactoryInterface;

/**
 * Modifies existing routes based on admin-configured paths.
 */
class RouteSubscriber extends RouteSubscriberBase {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected ConfigFactoryInterface $configFactory;

  /**
   * Constructs a RouteSubscriber object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * Alters existing routes dynamically.
   */
  protected function alterRoutes(RouteCollection $collection): void {
    $config = $this->configFactory->get('localgov_waste_collection.settings');
    $custom_base_path = $config->get('waste_collection_path');

    // Update the postcode form route dynamically.
    if ($route = $collection->get('localgov_waste_collection.form')) {
      if (!empty($custom_base_path)) {
        $route->setPath($custom_base_path);
      }

      $custom_form_title = $config->get('waste_collection_page_titles.form_pages');
      if (!empty($custom_form_title)) {
        $route->setDefault('_title', $custom_form_title);
      }
    }

    if ($route = $collection->get('localgov_waste_collection.find')) {
      if (!empty($custom_base_path)) {
        $route->setPath($custom_base_path . '/find');
      }

      $custom_form_title = $config->get('waste_collection_page_titles.form_pages');
      if (!empty($custom_form_title)) {
        $route->setDefault('_title', $custom_form_title);
      }
    }

    if ($route = $collection->get('localgov_waste_collection.view')) {
      if (!empty($custom_base_path)) {
        $route->setPath($custom_base_path . '/view/{uprn}');
      }

      $custom_results_title = $config->get('waste_collection_page_titles.results_page');
      if (!empty($custom_results_title)) {
        $route->setDefault('_title', $custom_results_title);
      }
    }

    if ($route = $collection->get('localgov_waste_collection.download')) {
      if (!empty($custom_base_path)) {
        $route->setPath($custom_base_path . '/download/{uprn}');
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    $events = parent::getSubscribedEvents();
    $events[RoutingEvents::ALTER] = ['onAlterRoutes', 100];
    return $events;
  }

  /**
   * Kernel request handler.
   */
  public function onKernelRequest(): void {
  }

}
