# Custom Data Providers

Local authorities in the UK and further afield use a wide variety of systems for waste collection management and address lookup. To accommodate this variety, the module uses the Drupal plugin system to allow the development of custom data providers.

Custom plugins can use any method of searching for addresses and providing waste collection schedules, provided they pass data to the base module in a standard format, described below.

## Plugin basics

* Must extend Drupal\localgov_waste_collection\DataProviderBase
* Must use the @DataProvider annotation
* Must implement these 3 methods:

### findAddressesByPostcode
Accepts a postcode (string) and returns an array of matching addresses.
### getAddressFromUprn
Accepts a UPRN (string) and returns the address of the property or NULL if not found.
### getCollections
Accepts a UPRN (string) and returns an array of waste collections for the respective property.

## Getting Started

A good place to start is the Example Data Provider sub-module. It's located in the
`modules/localgov_waste_collection_example_provider` directory. It's a small module, with only 3 files to review:

1. The README
2. The module info file
3. The @DataProvider plugin file ExampleDataProvider.php

The main implementation is in the @DataProvider plugin file ExampleDataProvider.php file. It
contains the required annotation and implements the required methods.

### Annotation

```php
/**
 * CSV waste collection data provider.
 *
 * @DataProvider(
 *   id = "@example ",
 *   label = @Translation("Example Data Provider")
 * )
 */
```

All elements in this annotation are required.

Drupal will use this annotation to detect the data provider plugin, and make it available for selection in the base module settings form:

![image](images/waste-collection-settings.png)

### Methods

#### findAddressesByPostcode

- Accepts a postcode string and returns an associative array of matching properties.
- Returns an empty array if no matches are found.
- Array key is the UPRN of the property, array value is the formatted address string, used in the property selector form:

![image](images/address-selector.png)

The example provider either returns an array of hard-coded addresses if the postcode value is `SF1 1AA`, or an empty array for any other postcode value.

#### getAddressFromUprn

- Accepts a UPRN.
- Returns a formatted single line address string, or null if not found.

This method is required to fetch and display the selected property address on the collection schedule page:

![image](images/selected-address.png)

#### getCollections

- Accepts a UPRN.
- Returns an array of collection dates, or an empty array if no collections are found for the property.
- Array must be in this format:


```
[
  "weekly_collection" => [
    "label" => "food waste",
    "day" => "Tuesday"
  ]
  "collection_time" => "06:30:00"
  "dates" => [
    0 => [
      "date" => "07-09-2030",
      "type" => [
        "label" => "Non-recyclable waste"
        "colour" => "Grey"
      ]
    ]
    1 => [
      "date" => "25-12-2030",
      "holiday" => "Christmas Day",
      "type" => [
        "label" => "Paper and cardboard"
        "colour" => "Blue"
      ]
    ]
  ]
]
```

`["weekly_collection"]` is an optional array that determines whether a weekly collection is included in the form:

_Your `label` will be collected every `day`_

`["collection_time"]` is an optional string that defines the collection time shown on the collection schedule and is used for event times in the ICS calendar download file. This can also be set in the module configuration form, the data provider value will over-ride this if present.

`["dates"]` should be ordered in ascending date order.

`["holiday"]` is an optional key that indicates the collection date coincides with a public holiday, the value contains the name of the holiday. See [Public Holidays](../README.md#public-holidays) in the module README for optional built-in public holiday support.

`["label"]` and `["colour"]` are used for rendering the calendar entries, and determine the shape and colour of the bin icon. These can be over-ridden in module or theme CSS.
