<?php

declare(strict_types=1);

namespace Drupal\localgov_waste_collection_example_provider\Plugin\DataProvider;

use Drupal\localgov_waste_collection\DataProviderBase;

/**
 * Example waste collection data provider.
 *
 * @DataProvider(
 *   id = "example_data_provider",
 *   label = @Translation("Example Data Provider")
 * )
 */
class ExampleDataProvider extends DataProviderBase {

  /**
   * {@inheritdoc}
   */
  public function findAddressesByPostcode(string $postcode): array {
    if (strtoupper($postcode) !== 'SF1 1AA') {
      return [];
    }

    return [
      '12345671' => '1 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345672' => '2 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345673' => '3 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345674' => '4 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345675' => '5 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345676' => '6 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345677' => '7 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345678' => '8 Surveillance Circular, Scarfolk. SF1 1AA',
      '12345679' => '9 Surveillance Circular, Scarfolk. SF1 1AA',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getAddressFromUprn(string $uprn): ?string {

    return '4 Surveillance Circular, Scarfolk. SF1 1AA';
  }

  /**
   * Get waste collections for a specified UPRN.
   *
   * @return array
   *   An array of waste collections.
   */
  public function getCollections(string $uprn): array {
    if ($uprn === '12345679') {
      return [];
    }

    return [
      "weekly_collection" => [
        "label" => "food waste",
        "day" => "Tuesday",
      ],
      "dates" => [
        0 => [
          "date" => "2030-10-01",
          "type" => [
            "label" => "Non-recyclable waste",
            "colour" => "Grey",
          ],
        ],
        1 => [
          "date" => "2030-10-01",
          "type" => [
            "label" => "Garden Waste",
            "colour" => "Green",
          ],
        ],
        2 => [
          "date" => "2030-10-08",
          "type" => [
            "label" => "Paper and cardboard",
            "colour" => "Blue",
          ],
        ],
        3 => [
          "date" => "2030-11-01",
          "type" => [
            "label" => "Non-recyclable waste",
            "colour" => "Grey",
          ],
        ],
        4 => [
          "date" => "2030-11-08",
          "type" => [
            "label" => "Paper and cardboard",
            "colour" => "Blue",
          ],
        ],
        5 => [
          "date" => "2030-12-25",
          "holiday" => "Christmas Day",
          "type" => [
            "label" => "Non-recyclable waste",
            "colour" => "Grey",
          ],
        ],
      ],
    ];
  }

}
