<?php

declare(strict_types=1);

namespace Drupal\localgov_waste_collection;

use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\localgov_waste_collection\Annotation\DataProvider;

/**
 * Provides the Data Provider plugin manager.
 */
class DataProviderManager extends DefaultPluginManager {

  /**
   * Constructor for DataProviderManager objects.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/DataProvider', $namespaces, $module_handler,
      DataProviderInterface::class,
      DataProvider::class);

    $this->alterInfo('data_provider_info');
    $this->setCacheBackend($cache_backend, 'data_provider_plugins');
  }

}
