<?php

namespace Drupal\Tests\localgov_waste_collection\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;
use Symfony\Component\HttpFoundation\Response;

/**
 * Tests the ICS file download for a given UPRN.
 *
 * @group localgov_waste_collection
 */
class DownloadCalendarTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'localgov_waste_collection',
    'localgov_waste_collection_example_provider',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $config = $this->config('localgov_waste_collection.settings');
    $config->set('active_data_provider', 'example_data_provider');
    $config->save();
  }

  /**
   * Tests the ICS download route returns a valid calendar file.
   */
  public function testCalendarDownload(): void {
    $user = $this->drupalCreateUser([
      'access content',
    ]);
    $this->drupalLogin($user);

    $uprn = '12345674';
    $url = Url::fromRoute('localgov_waste_collection.download', ['uprn' => $uprn])->toString();
    $this->drupalGet($url);

    // Assert headers.
    $this->assertSession()->statusCodeEquals(Response::HTTP_OK);
    $this->assertSession()->responseHeaderEquals('Content-Type', 'text/calendar; charset=utf-8');

    $disposition = $this->getSession()->getResponseHeader('Content-Disposition');
    $this->assertStringContainsString('attachment', $disposition);
    $this->assertStringContainsString($uprn . '.ics', $disposition);

    // Assert content.
    $content = $this->getSession()->getPage()->getContent();
    $this->assertStringContainsString('BEGIN:VCALENDAR', $content);
    $this->assertStringContainsString('END:VCALENDAR', $content);
    $this->assertStringContainsString('SUMMARY:Green lidded bins for Garden Waste', $content);
    $this->assertStringContainsString('UID:' . $uprn . '-2030-10-01-Green', $content);
  }

}
