<?php

/**
 * @file
 * API documentation for LocalGov Waste Collection module.
 */

/**
 * Allows other modules to alter the available data provider plugins.
 *
 * @param array $data_provider_info
 *   An associative array of plugin definitions, keyed by the plugin ID.
 *
 * @see \Drupal\localgov_waste_collection\Plugin\DataProvider\WasteProviderBase
 * @see \Drupal\localgov_waste_collection\Plugin\DataProvider\DataProviderManager
 */
function hook_data_provider_info_alter(array &$data_provider_info) {
  // Example: Change the label of a data provider plugin.
  if (isset($data_provider_info['example_data_provider'])) {
    $data_provider_info['example_data_provider']['label'] = t('Custom Provider Label');
  }
}
