# LocalGov Waste collection CSV data provider

This module provides a CSV data provider for authorities which may not have access to a third-party waste collection system or address gazetteer.

## How to use

- Enable the module and set it as the active data provider in the [parent module settings](../../README.md#configuration).
- Prepare the 3 required CSV files, and optionally a PDF file for each collection route (see file formats / naming below for details).
- Visit the CSV data provider settings form, select the mode for import, select the property CSV file, the collection rounds CSV file, the property to collections mapping CSV files, and submit the form.
- The import can take some time to process depending on the number of properties in the import file. After initial import use the 'Append and update' option and only include new or changed property records in the property import file.

## File formats
### Property file
3 columns:
- UPRN
- Postcode
- Formatted address

### Collection rounds file
4 columns:
- Round code
- Waste type
- Bin colour
- Collection date

### Property to collection round mapping file
2 columns:
- UPRN
- Round code

### PDF files
Named to match the round code, with a .pdf extension. This is case sensitive.

## Example files

Example CSV files are provided in the ``examples`` folder in the root of this sub-module:
- ```TestProperties.csv``` includes 2 properties with missing UPRNs.
- ```TestPropertiesUpdate.csv``` contains corrected data for those 2 properties and one additional property, to test the append and update import option.
- ```TestCollections.csv``` contains collection data for four collection rounds.
- ```TestPropertiesXCollections.csv``` contains property to collection mapping data - property with UPRN 12345678903 (3 Surveillance Circular, Scarfolk. SF1 1AA) demonstrates multiple rounds per property, which will also show multiple PDFs if uploaded:
- ```MONA.pdf``` is a sample PDF for the ```MONA``` round.
- ```WEDA.pdf``` is a sample PDF for the ```WEDA``` round.

