<?php

namespace Drupal\localized_config\Plugin\Menu;

use Drupal\Core\Language\LanguageManagerInterface;
use Drupal\Core\Menu\MenuLinkBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\localized_config\LocalizedConfigHelper;
use Drupal\localized_config\LocalizedConfigLanguageHelper;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Creates link to localized config depending on serveral conditions.
 *
 * @package Drupal\localized_config\Plugin\Menu
 */
class LocalizedConfigDynamicMenuLink extends MenuLinkBase implements ContainerFactoryPluginInterface {

  /**
   * Constructs a new bubbling URL generator service.
   *
   * @param array $configuration
   *   Configuration.
   * @param string $plugin_id
   *   Plugin ID.
   * @param mixed $plugin_definition
   *   Plugin definition.
   * @param \Drupal\localized_config\LocalizedConfigHelper $localizedConfigHelper
   *   Localized config helper.
   * @param \Drupal\Core\Session\AccountInterface $currentUser
   *   The current user.
   * @param \Drupal\Core\Language\LanguageManagerInterface $languageManager
   *   The language manager service.
   * @param \Drupal\localized_config\LocalizedConfigLanguageHelper $languageHelper
   *   Localized Config language-related methods.
   */
  public function __construct(array $configuration, $plugin_id, mixed $plugin_definition, protected LocalizedConfigHelper $localizedConfigHelper, protected AccountInterface $currentUser, protected LanguageManagerInterface $languageManager, protected LocalizedConfigLanguageHelper $languageHelper) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static($configuration, $plugin_id, $plugin_definition, $container->get('localized_config.helper'), $container->get('current_user'), $container->get('language_manager'), $container->get('localized_config.language_helper'));
  }

  /**
   * {@inheritdoc}
   */
  public function getTitle(): string {
    return $this->pluginDefinition['title'];
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): string {
    return $this->pluginDefinition['description'];
  }

  /**
   * {@inheritdoc}
   */
  public function updateLink(array $new_definition_values, $persist): array {
    return $this->pluginDefinition;
  }

  /**
   * {@inheritdoc}
   */
  public function getRouteParameters(): array {
    $language_parameter = $this->localizedConfigHelper->languagesSupported() ? $this->languageHelper->firstAccessibleLanguage() : '';
    return [
      'language' => $language_parameter,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheContexts(): array {
    return ['user'];
  }

}
