(function (window, Drupal, drupalSettings) {
  'use strict';

  Drupal.behaviors.LocalizeJsBehavior = {
    attach: function (context, settings) {

    var buttons =  document.querySelectorAll('.localize-links-container button');

    function localizeAddActive() {
      if (typeof Localize !== 'undefined') {
        var currentLanguage = Localize.getLanguage();
        buttons.forEach(function(button) {
          button.classList.remove('active');
        });
        var currentButton = document.querySelector('.localize-links-container button[data-language=' + currentLanguage + ']');
        currentButton.classList.add('active');
      }
    }

    if (drupalSettings.localizejs.language_switcher.useDomains) {
      var languages = Object.values(drupalSettings.localizejs.language_switcher.languages);
      var language = languages.find(function(o) { return o.domain === window.location.hostname; });
      if (language) {
        if (typeof Localize !== 'undefined') {
          Localize.setLanguage(language.code);
        }
      }
    }
    else {
      buttons.forEach(function(button) {
        button.addEventListener('click', localizeAddActive);
      });
    }

    localizeAddActive();

    }
  };

})(window, Drupal, drupalSettings);
