<?php

namespace Drupal\localizejs\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\localizejs\LanguageInterface;


/**
 * Defines the language entity type.
 *
 * @ConfigEntityType(
 *   id = "localizejs_language",
 *   label = @Translation("Language"),
 *   label_singular = @Translation("language"),
 *   label_plural = @Translation("languages"),
 *   label_collection = @Translation("Languages"),
 *   label_count = @PluralTranslation(
 *     singular = "@count language",
 *     plural = "@count languages",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\localizejs\LanguageListBuilder",
 *     "form" = {
 *       "add" = "Drupal\localizejs\Form\LanguageForm",
 *       "edit" = "Drupal\localizejs\Form\LanguageForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm"
 *     }
 *   },
 *   config_prefix = "language",
 *   admin_permission = "administer localizejs",
 *   links = {
 *     "collection" = "/admin/config/system/localizejs/languages",
 *     "add-form" = "/admin/config/system/localizejs/languages/add",
 *     "edit-form" = "/admin/config/system/localizejs/languages/edit/{localizejs_language}",
 *     "delete-form" = "/admin/config/system/localizejs/languages/delete/{localizejs_language}"
 *   },
 *   entity_keys = {
 *     "id" = "code",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *     "weight" = "weight"
 *   },
 *   config_export = {
 *     "code",
 *     "label",
 *     "domain",
 *     "weight"
 *   }
 * )
 */
class Language extends ConfigEntityBase implements LanguageInterface {

  /**
   * The language short code.
   *
   * @var string
   */
  protected $code;

  /**
   * Label of the language.
   *
   * @var string
   */
  protected $label;

  /**
   * Domain where the language is applied.
   *
   * @var string
   */
  protected $domain;

  /**
   * The weight of this language in relation to others.
   *
   * @var int
   */
  protected $weight = 0;

  /**
   * {@inheritdoc}
   */
  public function id() {
    return $this->code;
  }

  /**
   * {@inheritdoc}
   */
  public function getDomain() {
    return $this->domain;
  }

}
