<?php

namespace Drupal\localizejs\Form;

use Drupal\Core\Entity\EntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Language form.
 *
 * @property \Drupal\localizejs\LanguageInterface $entity
 */
class LanguageForm extends EntityForm {

  /**
   * {@inheritdoc}
   */
  public function form(array $form, FormStateInterface $form_state) {
    $config = $this->config('localizejs.settings');

    $form = parent::form($form, $form_state);

    $form['label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Label'),
      '#maxlength' => 60,
      '#default_value' => $this->entity->label(),
      '#description' => $this->t('Label of the language.'),
      '#required' => TRUE,
    ];

    $form['code'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Code'),
      '#maxlength' => 5,
      '#default_value' => $this->entity->id(),
      '#description' => $this->t('Language short code.'),
      '#disabled' => !$this->entity->isNew(),
      '#required' => TRUE,
    ];

    $form['domain'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Domain'),
      '#default_value' => $this->entity->getDomain(),
      '#description' => $this->t('Domain corresponding to the language.'),
      '#required' => !empty($config->get('use_domains')),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);
    $message_args = ['%label' => $this->entity->label()];
    $message = $result == SAVED_NEW
      ? $this->t('Created new language %label.', $message_args)
      : $this->t('Updated language %label.', $message_args);
    $this->messenger()->addStatus($message);
    $form_state->setRedirectUrl($this->entity->toUrl('collection'));
    return $result;
  }

}
