<?php

namespace Drupal\localizejs\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Implements the module settings form.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'localizejs.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'localizejs_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('localizejs.settings');

    $form['project_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Project key'),
      '#description' => $this->t('Put here your localize project key. Create your project on https://localizejs.com.'),
      '#default_value' => $config->get('project_key'),
    ];

    $form['disable_admin'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable Localizejs on administrative pages'),
      '#default_value' => $config->get('disable_admin'),
    ];

    $form['disable_authenticated_users'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable Localizejs for authenticated users'),
      '#default_value' => $config->get('disable_authenticated_users'),
    ];

    $form['use_domains'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use domains'),
      '#description' => $this->t('Changing this would require to clear cache in order to make the language switcher block work correctly'),
      '#default_value' => $config->get('use_domains'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();
    $this->configFactory->getEditable('localizejs.settings')
      ->set('project_key', $values['project_key'])
      ->set('disable_admin', $values['disable_admin'])
      ->set('disable_authenticated_users', $values['disable_authenticated_users'])
      ->set('use_domains', $values['use_domains'])
      ->save();

    parent::submitForm($form, $form_state);
  }

}
