<?php

namespace Drupal\localizejs;

use Drupal\Core\Config\Entity\DraggableListBuilder;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Form\FormStateInterface;

/**
 * Defines a class to build a listing of language entities.
 *
 * @see \Drupal\localizejs\Entity\Language
 */
class LanguageListBuilder extends DraggableListBuilder {

  /**
   * {@inheritdoc}
   */
  protected $entitiesKey = 'languages';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'localizejs_overview_languages';
  }

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['label'] = $this->t('Label');
    $header['code'] = $this->t('Code');
    $header['domain'] = $this->t('Domain');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\localizejs\LanguageInterface $entity */
    $row['label'] = $entity->label();
    $row['code']['data'] = ['#markup' => $entity->id()];
    $row['domain']['data'] = ['#markup' => $entity->getDomain()];
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $form['actions']['submit']['#value'] = t('Save');

    return $form;
  }

}
