(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.resetDefaultValues = {
    attach: function (context) {
      const buttons = once('reset-button-click', '#reset-default-values', context);

      buttons.forEach((button) => {
        button.addEventListener('click', function (e) {
          e.preventDefault();

          const defaults = drupalSettings.lodge?.defaultDataValues || {};

          Object.entries(defaults).forEach(([key, value]) => {
            const input = context.querySelector(`input[name="${key}"]`);
            if (input) {
              input.value = value;
            }
          });

          // Crear un mensaje personalizado
          const messageDiv = document.createElement('div');
          messageDiv.className = 'color-reset-message';
          messageDiv.textContent = 'Los colores se restablecieron a sus valores por defecto.';

          // Añadir estilos básicos
          messageDiv.style.marginBottom = '1em';
          messageDiv.style.padding = '1em';
          messageDiv.style.backgroundColor = '#dff0d8';
          messageDiv.style.border = '1px solid #d6e9c6';
          messageDiv.style.color = '#3c763d';
          messageDiv.style.borderRadius = '4px';
          messageDiv.style.opacity = '1';
          messageDiv.style.transition = 'opacity 0.5s ease';

          // Insertar el mensaje arriba del botón
          const parent = button.parentNode;
          const existing = parent.querySelector('.color-reset-message');
          if (existing) existing.remove(); // Elimina mensaje anterior si ya existe

          parent.insertBefore(messageDiv, button);

          // Desaparecer el mensaje después de 3 segundos
          setTimeout(() => {
            messageDiv.style.opacity = '0';
            setTimeout(() => messageDiv.remove(), 500); // Espera que termine la transición
          }, 3000);
        });
      });
    }
  };
})(Drupal, drupalSettings, once);
