<?php

namespace Drupal\log_cache_tags\Cache;

use Drupal\Core\Cache\CacheTagsInvalidatorInterface;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\State\StateInterface;
use Psr\Log\LogLevel;

/**
 * Cache tags invalidator service which logs the invalidated cache tags.
 */
class InvalidTagsLogger implements CacheTagsInvalidatorInterface {

  /**
   * Constructs a new \Drupal\log_cache_tags\Cache\InvalidTagsLogger object.
   *
   * @param \Drupal\Core\State\StateInterface $state
   *   The state service.
   * @param \Drupal\Core\Logger\LoggerChannelFactoryInterface $loggerFactory
   *   The logger channel factory service.
   */
  public function __construct(
    protected StateInterface $state,
    protected LoggerChannelFactoryInterface $loggerFactory,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function invalidateTags(array $tags): void {
    $args = ['@tags' => implode(', ', $tags)];

    if ($this->state->get('log_cache_tags_log_invalidated_tags', FALSE)) {
      $this->loggerFactory->get('log_cache_tags')->log(LogLevel::NOTICE, 'Invalidated cache tags: @tags', $args);
    }
  }

}
