<?php

declare(strict_types=1);

namespace Drupal\logged_in\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Service class for implementing module hooks for Logged In.
 */
class LoggedInHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_views_data().
   *
   * @return array
   *   The views data.
   *
   * @phpstan-ignore-next-line
   */
  #[Hook('views_data')]
  public function viewsData(): array {
    $data['views']['table']['group'] = $this->t('Custom Global');
    $data['views']['table']['join'] = [
      '#global' => [],
    ];

    $data['views']['logged_in'] = [
      'title' => $this->t('Logged in'),
      'help' => $this->t('Checks if a user is logged in.'),
      'field' => [
        'id' => 'logged_in',
      ],
    ];

    return $data;
  }

}
