<?php

namespace Drupal\logger\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;

/**
 * Interface for logger target plugins.
 */
interface LoggerTargetInterface extends PluginInspectionInterface {

  /**
   * Persists a log entry string to the target.
   *
   * @param string $entry
   *   The log entry as a rendered string (in JSON format).
   * @param int $level
   *   The log level.
   *
   * @throws \Exception
   *   When the target cannot be reached or persisting fails.
   */
  public function persist(string $entry, int $level): void;

  /**
   * Validates the target configuration.
   *
   * @param array $target
   *   The target configuration array.
   *
   * @return bool
   *   TRUE if the configuration is valid, FALSE otherwise.
   */
  public function validateTarget(array $target): bool;

  /**
   * Gets the default configuration for this target type.
   *
   * @return array
   *   The default configuration.
   */
  public function getDefaultConfiguration(): array;

}
