<?php

declare(strict_types=1);

namespace Drupal\Tests\logger\Unit;

use Drupal\logger\LoggerEntry;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Tests for the LoggerEntry class.
 */
#[CoversClass(LoggerEntry::class)]
#[Group('logger')]
class LoggerEntryTest extends UnitTestCase {

  /**
   * Tests general LoggerEntry functionality.
   *
   * This test covers basic operations like construction, getting/setting data,
   * deleting fields, and string conversion.
   */
  public function testGeneral() {
    $entry0 = new LoggerEntry();
    $this->assertEquals([], $entry0->getData());

    $data1 = ['foo' => 'bar', 'baz' => 'qix'];
    $entry1 = new LoggerEntry($data1);
    $this->assertEquals($data1, $entry1->getData());
    $this->assertEquals($data1['foo'], $entry1->get('foo'));

    $data2 = $data1 + ['fred' => 'thud'];
    $entry1->set('fred', $data2['fred']);
    $this->assertEquals($data2, $entry1->getData());
    $this->assertEquals($data2['fred'], $entry1->get('fred'));
    $this->assertEquals(json_encode($data2), $entry1->__toString());

    $entry1->delete('fred');
    $this->assertEquals($data1, $entry1->getData());

    $entry1->setData($data2);
    $this->assertEquals($data2['fred'], $entry1->get('fred'));
  }

}
