<?php

declare(strict_types=1);

namespace Drupal\Tests\logger\Unit;

use Drupal\Core\Logger\RfcLogLevel;
use Drupal\logger\Plugin\LoggerTarget\File;
use Drupal\test_helpers\TestHelpers;
use Drupal\Tests\logger\Utils\UtilsTrait;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Unit tests for the File logger target plugin.
 */
#[CoversClass(File::class)]
#[Group('logger')]
class LoggerTargetFileTest extends UnitTestCase {

  use UtilsTrait;

  /**
   * Tests the file logger plugin persists messages to a file.
   */
  public function testPlugin() {
    $tmpDir = sys_get_temp_dir();
    TestHelpers::getContainer();
    $this->addPluginToDefinitions(File::class);
    $file1 = tempnam($tmpDir, 'log_file_1_');
    $instance = TestHelpers::service('plugin.manager.logger_target')->createInstance('file', ['path' => $file1]);
    $instance->persist('foo', RfcLogLevel::WARNING);
    $instance->persist('bar', RfcLogLevel::WARNING);
    $data = file($file1, FILE_IGNORE_NEW_LINES);
    $this->assertEquals(['foo', 'bar'], $data);
    unlink($file1);

    $file2 = tempnam($tmpDir, 'log_file_2_');
    $this->mockStreamWrapperManager($file2);
    $instance = TestHelpers::service('plugin.manager.logger_target')->createInstance('file', ['path' => "temporary://no-matter-here"]);
    $instance->persist('foo', RfcLogLevel::WARNING);
    $instance->persist('bar', RfcLogLevel::WARNING);
    $data = file("$file2", FILE_IGNORE_NEW_LINES);
    $this->assertEquals(['foo', 'bar'], $data);
    unlink("$file2");
  }

}
