<?php

declare(strict_types=1);

namespace Drupal\Tests\logger\Unit;

use Drupal\Core\Logger\RfcLogLevel;
use Drupal\logger\Plugin\LoggerTarget\Output;
use Drupal\test_helpers\TestHelpers;
use Drupal\Tests\logger\Utils\UtilsTrait;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Unit tests for the Output logger target plugin.
 */
#[CoversClass(Output::class)]
#[Group('logger')]
class LoggerTargetOutputTest extends UnitTestCase {

  use UtilsTrait;

  /**
   * Tests the output logger plugin writes to stdout/stderr.
   */
  public function testPlugin() {
    // @todo Rework to better implementation checking the real output.
    $calls = TestHelpers::mockPhpFunction('file_put_contents', Output::class);

    $this->addPluginToDefinitions(Output::class);
    $instance = TestHelpers::service('plugin.manager.logger_target')->createInstance('output', ['stream' => 'stderr']);
    $instance->persist('foo', RfcLogLevel::WARNING);

    $instance = TestHelpers::service('plugin.manager.logger_target')->createInstance('output', ['stream' => 'stdout']);
    $instance->persist('bar', RfcLogLevel::DEBUG);

    $this->assertEquals('php://stderr', $calls[0][0]);
    $this->assertEquals("foo\n", $calls[0][1]);

    $this->assertEquals('php://stdout', $calls[1][0]);
    $this->assertEquals("bar\n", $calls[1][1]);

    TestHelpers::unmockAllPhpFunctions();
  }

}
