<?php

declare(strict_types=1);

namespace Drupal\Tests\logger\Unit;

use Drupal\Core\Logger\RfcLogLevel;
use Drupal\logger\Plugin\LoggerTarget\Output;
use Drupal\logger\Plugin\LoggerTarget\Syslog;
use Drupal\test_helpers\TestHelpers;
use Drupal\Tests\logger\Utils\UtilsTrait;
use Drupal\Tests\UnitTestCase;
use PHPUnit\Framework\Attributes\CoversClass;
use PHPUnit\Framework\Attributes\Group;

/**
 * Unit tests for the Syslog logger target plugin.
 */
#[CoversClass(Output::class)]
#[Group('logger')]
class LoggerTargetSyslogTest extends UnitTestCase {

  use UtilsTrait;

  /**
   * Tests the syslog logger plugin opens connection and sends messages.
   */
  public function testPlugin() {
    $callsOpenlog = TestHelpers::mockPhpFunction('openlog', Syslog::class, function () {
      return TRUE;
    });
    $calls = TestHelpers::mockPhpFunction('syslog', Syslog::class);

    $this->addPluginToDefinitions(Syslog::class);
    $instance = TestHelpers::service('plugin.manager.logger_target')->createInstance('syslog', [
      'prefix' => 'test1',
      'facility' => LOG_USER,
    ]);
    $instance->persist('foo', RfcLogLevel::WARNING);

    $instance = TestHelpers::service('plugin.manager.logger_target')->createInstance('syslog', [
      'prefix' => 'test2',
      'facility' => LOG_DEBUG,
    ]);
    $instance->persist('bar', RfcLogLevel::DEBUG);

    $this->assertEquals('test1', $callsOpenlog[0][0]);
    $this->assertEquals(LOG_USER, $callsOpenlog[0][2]);
    $this->assertEquals(RfcLogLevel::WARNING, $calls[0][0]);
    $this->assertEquals("foo", $calls[0][1]);

    $this->assertEquals('test2', $callsOpenlog[1][0]);
    $this->assertEquals(LOG_DEBUG, $callsOpenlog[1][2]);
    $this->assertEquals(RfcLogLevel::DEBUG, $calls[1][0]);
    $this->assertEquals("bar", $calls[1][1]);

    TestHelpers::unmockAllPhpFunctions();
  }

}
