<?php

namespace Drupal\Tests\logger\Utils;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\logger\Attribute\LoggerTarget;
use Drupal\logger\Plugin\LoggerTargetBase;

/**
 * Provides a test target.
 */
#[LoggerTarget(
  id: 'test2',
  label: new TranslatableMarkup('Test2'),
  description: new TranslatableMarkup('A test helper logger target 2 for unit tests.'),
  weight: 10
)]
class LogTargetTest2Plugin extends LoggerTargetBase {

  /**
   * A static array to store log entries for testing purposes.
   *
   * @var array
   */
  public static array $logs = [];

  /**
   * {@inheritdoc}
   */
  public function persist(string $entry, $level): void {
    self::$logs[] = [
      'configuration' => $this->configuration,
      'entry' => $entry,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function validateTarget(array $target): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultConfiguration(): array {
    return ['foo' => 'bar'];
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigForm() {
    return [];
  }

  /**
   * Resets the static logs array.
   */
  public static function resetStaticCache(): void {
    self::$logs = [];
  }

}
