<?php

namespace Drupal\logger\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines a logger target plugin attribute object.
 *
 * @see \Drupal\logger\Plugin\LoggerTargetInterface
 * @see \Drupal\logger\Plugin\LoggerTargetManager
 * @see plugin_api
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class LoggerTarget extends Plugin {

  /**
   * The human-readable name of the logger target.
   */
  public TranslatableMarkup|string $label;

  /**
   * A brief description of the logger target.
   */
  public TranslatableMarkup|string $description;

  /**
   * The weight of the plugin.
   */
  public int $weight;

  /**
   * Constructs a LoggerTarget attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $label
   *   The human-readable name of the logger target.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|string $description
   *   A brief description of the logger target.
   * @param int $weight
   *   The weight of the plugin.
   * @param class-string|null $deriver
   *   The deriver class.
   */
  public function __construct(
    string $id,
    TranslatableMarkup|string $label,
    TranslatableMarkup|string $description = '',
    int $weight = 0,
    ?string $deriver = NULL,
  ) {
    parent::__construct($id, $deriver);
    $this->label = $label;
    $this->description = $description;
    $this->weight = $weight;
  }

}
