<?php

namespace Drupal\logger\Event;

use Drupal\Component\EventDispatcher\Event;
use Drupal\logger\LoggerEntry;

/**
 * Event that is fired before a new log entry is being persisted.
 */
class LoggerLogEvent extends Event {

  /**
   * Constructs the object.
   *
   * @param \Drupal\logger\LoggerEntry $entry
   *   The LoggerEntry object with the log entry data.
   * @param mixed $level
   *   The log level.
   * @param mixed $message
   *   The log message.
   * @param array $context
   *   The log context array.
   */
  public function __construct(
    public LoggerEntry $entry,
    public $level,
    public $message,
    public array $context,
  ) {
  }

}
