<?php

namespace Drupal\logger\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for logger target plugins.
 */
abstract class LoggerTargetBase extends PluginBase implements LoggerTargetInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function validateTarget(array $target): bool {
    return !empty($target['destination']);
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultConfiguration(): array {
    return [
      'destination' => '',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigForm() {
    return [];
  }

}
