<?php

namespace Drupal\logger\Util;

use Ahc\Json\Fixer;

/**
 * Contains Logger utils.
 */
class LoggerUtils {

  const CUT_SUFFIX = '_cut_"';

  /**
   * Converts an array of form options into a list of selected values.
   *
   * @param array $options
   *   The submitted values from the form.
   *
   * @return array
   *   An array of values that were checked.
   */
  public static function formOptionsToList(array $options): array {
    return array_values(array_filter($options, function ($value) {
      return $value != 0;
    }, ARRAY_FILTER_USE_BOTH));
  }

  /**
   * Truncates a JSON string to the maximum length as valid JSON.
   *
   * @param string $string
   *   The JSON string.
   * @param int $maxLength
   *   The maximum length.
   *
   * @return string
   *   The truncated valid JSON string.
   */
  public static function truncateJsonString(string $string, int $maxLength): string {
    if (strlen($string) <= $maxLength) {
      return $string;
    }
    $jsonFixer = new Fixer();
    $cutIndicatorLength = strlen(self::CUT_SUFFIX);
    $cutPos = $maxLength - $cutIndicatorLength - 1;
    do {
      $stringCut = substr($string, 0, $cutPos) . self::CUT_SUFFIX;
      try {
        $truncated = $jsonFixer->fix($stringCut);
        $truncatedLength = strlen($truncated);
      }
      catch (\Exception) {
        $truncatedLength = $maxLength + 1;
      }
      $cutPos -= 1;
    } while ($truncatedLength > $maxLength);
    return $truncated;
  }

}
