# Logger

A Drupal Logger that provides a production-ready lightweight structured logging
approach, allowing to store any additional metadata as custom fields together
with the log entry in JSON format as a nested data structure.

Supports logging to any target: stdout, stderr, file, syslog, database, http,
clouds, extendable by plugins to support any new target.

## Features

- Generates logs in JSON format, including only the fields you want to see, not
  all the defaults.
- Allows storing any additional custom metadata together with a log record as a
  raw nested structure with custom fields.
- Provides an option to store raw log messages with unreplaced placeholders,
  storing the placeholder values in separate JSON fields.

## Installation

Simply install the module and it will start working with the default settings
with no special requirements.

To attach metadata to the log entry, you don't need to use anything new! Just
use the standard PSR-3 Logger Interface and attach your custom fields as a
free-form nested array to the `$context['metadata']` like this:
```php
 $logger->log(
  level: LogLevel::INFO,
  message: 'My custom operation',
  context: [
    'any' => [
      'structured' => [
        'data' => 'here',
      ]
    ]
  ],
);
```

By default, the module stores logs in the file `temporary://drupal-log.jsonl`
to make it work on any environment out of the box.. But logging to files is not
an optimal way for performance reasons, therefore it's better to change the
default output target and other settings on the page Configuration » Development
» Logger (path `/admin/config/development/logger`).

## Recommended Logging Approach

**For production:** the best approach is to output logs to `stderr`, which can
be captured and parsed by a log scraper such as Grafana Loki, Fluentd, the ELK
Stack (Elasticsearch, Logstash, Kibana), OpenTelemetry Logs, Promtail, Splunk,
Datadog, Graylog, Logz.io, and others.

**For testing and local environments:** the most convenient way is to store
logs in the Drupal SQL database. This functionality is provided by a separate
module, [Logger DB](https://drupal.org/project/logger_db), to keep
the base module minimal, lightweight, and suitable for production.

You can switch the log target on the fly per environment by overriding the
config value in the `settings.php` like this:
```php
if (getenv('SITE_ENV') !== 'production') {
  $config['logger.settings']['targets'][0]['plugin'] = 'database';
  $config['logger.settings']['targets'][0]['configuration'] = '{}';
}
```

## Additional modules

- [Logger DB](https://drupal.org/project/logger_db): stores logs directly
in the Drupal database.

- [Request Logger](https://drupal.org/project/request_logger): logs every
request to Drupal with performance metrics (duration, memory usage, cache status,
etc).

## Similar Projects

There are many modules that provide extended logging for Drupal, but none of
them allow storing custom data in the log entry. Here is a list of alternatives:

- [JSONlog](https://www.drupal.org/project/jsonlog)
- [Monolog](https://www.drupal.org/project/monolog)
- [Object Log](https://www.drupal.org/project/object_log)
- [Past Log](https://www.drupal.org/project/past)
- [File Log](https://www.drupal.org/project/filelog)

However, all of them only store the log message text in the log entry, with no
way to store additional structured data.

So, seems this module is the only solution for Drupal to store structured
metadata together with the log entry? Tell me if I'm wrong!

### Supporting this Module

You can show your appreciation for the development of this module and motivate
further work through these services: [![GitHub sponsor
me](https://drupal.org//files/github-sponsor-button.png)](https://github.com/sponsors/MurzNN)
[![Coindrop.to me](https://drupal.org//files/coindrop-embed-button.png)](https://coindrop.to/murz)
[![Buy Me a
Coffee](https://drupal.org/files/by-me-a-coffee-button.png)](https://www.buymeacoffee.com/murz)
