<?php

namespace Drupal\logger\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\logger\LoggerEntryInterface;

/**
 * Interface for logger target plugins.
 */
interface LoggerTargetInterface extends PluginInspectionInterface {

  /**
   * Persists a log entry string to the target.
   *
   * @param \Drupal\logger\LoggerEntryInterface $entry
   *   The log entry object.
   *
   * @throws \Exception
   *   When the target cannot be reached or persisting fails.
   */
  public function persist(LoggerEntryInterface $entry): void;

  /**
   * Validates the target configuration.
   *
   * @param array $target
   *   The target configuration array.
   *
   * @return bool
   *   TRUE if the configuration is valid, FALSE otherwise.
   */
  public function validateTarget(array $target): bool;

  /**
   * Gets the default configuration for this target type.
   *
   * @return array
   *   The default configuration.
   */
  public function getDefaultConfiguration(): array;

}
