<?php

declare(strict_types=1);

namespace Drupal\Tests\logger\Utils;

use Drupal\Core\StreamWrapper\StreamWrapperInterface;
use Drupal\logger\Attribute\LoggerTarget;
use Drupal\test_helpers\TestHelpers;

/**
 * Trait providing utility methods for logger tests.
 */
trait UtilsTrait {

  /**
   * Helper to add a logger target plugin definition.
   */
  private function addPluginToDefinitions(string $class) {
    $reflection = new \ReflectionClass($class);
    // Read the LoggerTarget PHP attribute to get the plugin id.
    $attributes = $reflection->getAttributes(LoggerTarget::class);
    if (!empty($attributes)) {
      $attribute_instance = $attributes[0]->newInstance();
      // The attribute stores its id in the public property 'id'.
      $id = $attribute_instance->id ?? $class;
    }
    else {
      // Fallback: use the short class name as an id.
      $id = $class;
    }

    $definition = [
      'class' => $class,
      'provider' => 'logger',
    ];

    $pluginManager = TestHelpers::service('plugin.manager.logger_target', initService: TRUE);
    $definitions = TestHelpers::getPrivateProperty($pluginManager, 'definitions');
    $definitions[$id] = $definition;
    TestHelpers::setPrivateProperty($pluginManager, 'definitions', $definitions);
  }

  /**
   * Mocks the stream wrapper manager to return a specific real path.
   *
   * @param string $realpath
   *   The real path to return when getViaUri()->realpath() is called.
   */
  private function mockStreamWrapperManager(string $realpath) {
    $streamWrapperManager = TestHelpers::service('stream_wrapper_manager', initService: FALSE);
    $streamWrapperInterface = $this->createMock(StreamWrapperInterface::class);
    $streamWrapperInterface->method('realpath')->willReturn($realpath);
    $streamWrapperManager->method('getViaUri')->willReturn($streamWrapperInterface);
  }

}
