<?php

/**
 * @file
 * Provide views data for the Logger DB module.
 */

use Drupal\logger_db\Plugin\LoggerTarget\Db;

/**
 * Implements hook_views_data().
 */
function logger_db_views_data() {
  $data[Db::DB_TABLE] = [
    'table' => [
      'group' => t('Logger'),
      'base' => [
        // A workaround for an issue to allow custom field plugins for
        // aggregation.
        // @see https://www.drupal.org/project/drupal/issues/3541066
        'query_id' => 'logger_db_query',
        // The 'field' key here identifies the primary id field for Views
        // (used in joins/relationships). To control which field the Views
        // wizard auto-adds when creating a new view, provide the
        // 'defaults' => ['field' => '<field_id>'] entry (see
        // WizardPluginBase::defaultDisplayOptions()).
        'field' => 'uuid',
        'defaults' => [
          // Make the wizard add the 'time' field by default when a new
          // view is created for this base table.
          'field' => 'message',
        ],
        'title' => t('Logger Logs'),
        'help' => t('Log entries from the Logger module.'),
      ],
    ],
    'uuid' => [
      'title' => t('UUID'),
      'help' => t('The internal entry id in the database.'),
      'field' => ['id' => 'standard'],
      'filter' => ['id' => 'string'],
      'argument' => ['id' => 'string'],
      'sort' => ['id' => 'standard'],
    ],
    'severity' => [
      'title' => t('Severity'),
      'help' => t('The severity level of the event; ranges from 0 (Emergency) to 7 (Debug).'),
      'field' => [
        'id' => 'logger_db_severity',
      ],
      'filter' => [
        'id' => 'in_operator',
        'options callback' => 'Drupal\Core\Logger\RfcLogLevel::getLevels',
      ],
      'sort' => ['id' => 'standard'],
    ],
    'channel' => [
      'title' => t('Channel'),
      'help' => t('The channel of the log entry, which can be used to categorize logs.'),
      'argument' => ['id' => 'string'],
      'field' => ['id' => 'standard'],
      'filter' => ['id' => 'logger_db_channel'],
      'sort' => ['id' => 'standard'],
    ],
    'time' => [
      'title' => t('Time'),
      'help' => t('The log entry time, with millisecond precision.'),
      'field' => ['id' => 'logger_db_time'],
      'filter' => ['id' => 'logger_db_time_range'],
      'sort' => ['id' => 'standard'],
    ],
    'message' => [
      'title' => t('Message'),
      'help' => t('The log message associated with the event. Tokens will be replaced to values from the context.'),
      'argument' => ['id' => 'string'],
      'field' => ['id' => 'logger_db_message'],
      'filter' => ['id' => 'string'],
      'sort' => ['id' => 'standard'],
    ],
    'data' => [
      'title' => t('Log entry data'),
      'help' => t('Display data values from the log entry.'),
      'argument' => ['id' => 'string'],
      'field' => ['id' => 'logger_db_data'],
      'filter' => ['id' => 'string'],
      'sort' => ['id' => 'standard'],
    ],
    'log_value' => [
      'title' => t('Log value'),
      'help' => t('A single log entry value by path.'),
      'field' => ['id' => 'logger_db_log_value'],
    ],
    'log_value_string' => [
      'title' => t('Log Value (String)'),
      'help' => t('Filter by a log entry value as string.'),
      'filter' => ['id' => 'logger_db_log_value_string'],
      'real field' => 'data',
    ],
    'log_value_numeric' => [
      'title' => t('Log Value (Numeric)'),
      'help' => t('Filter by a log entry value as numeric.'),
      'filter' => ['id' => 'logger_db_log_value_numeric'],
      'real field' => 'data',
    ],
  ];
  return $data;
}
