<?php

namespace Drupal\logger_db;

use Drupal\Core\Extension\ExtensionPathResolver;

use Drupal\Core\Config\FileStorage;
use Drupal\views\Entity\View;

/**
 * Persist a log entry to the database.
 */
class LoggerDbUtils {

  /**
   * Constructs an LoggerDbUtils object.
   *
   * @param \Drupal\Core\Extension\ExtensionPathResolver $extensionPathResolver
   *   The extension path resolver service.
   */
  public function __construct(
    protected ExtensionPathResolver $extensionPathResolver,
  ) {
  }

  /**
   * Resets the Logger Views page settings to defaults.
   */
  public function resetView(): void {
    $moduleDirectory = $this->extensionPathResolver->getPath('module', 'logger_db');
    $configStorage = new FileStorage($moduleDirectory . '/config/install');
    $configName = 'views.view.logger_db_logs';

    $configData = $configStorage->read($configName);

    /** @var \Drupal\views\ViewEntityInterface $view */
    $view = View::load('logger_db_logs');
    foreach ($configData as $key => $value) {
      $view->set($key, $value);
    }
    $view->save();
  }

}
