<?php

namespace Drupal\logger_db\Plugin\views\field;

use Drupal\logger\Logger\Logger;
use Drupal\views\Attribute\ViewsField;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Provides a field handler that renders a log severity.
 */
#[ViewsField("logger_db_severity")]
class LoggerDbSeverity extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function render(ResultRow $values) {
    $level = $this->getValue($values);
    $rendered = Logger::getRfcLogLevelAsString($level);
    return $this->sanitizeValue($rendered);
  }

}
