<?php

namespace Drupal\logger_db\Plugin\views\field;

/**
 * Provides a field handler that renders a log severity.
 */
trait LoggerDbValueJsonQueryTrait {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->ensureMyTable();
    $expression = $this->getJsonExpression($this->tableAlias . '.data', $this->options['value_path']);
    $params = [];
    if (
      $this->options['group_type']
      && $this->options['group_type'] !== 'group'
    ) {
      $params['function'] = $this->options['group_type'];
    }
    $this->field_alias = $this->query->addField(NULL, $expression, $this->field, $params);
  }

}
