const assert = require('assert');
const utils = require('../Lib/ViewsUtils');

module.exports = {
  '@tags': ['logger_db', 'logger_db-matrix'],
  before(browser) {
    browser.drupalInstall({
      installProfile: 'logger_db_test_profile',
    });
  },
  after(browser) {
    browser.drupalUninstall();
  },
  'Views JSON Plugin': async (browser) => {
    browser.window
      // To include more details into the screenshot. Should be set after
      // visiting the first page on the domain, not before.
      .setSize(1920, 2500)
      .thLogin('admin')
      .drupalRelativeURL('/admin/reports/logs?channel[]=logger_db_test')
      .execute("document.body.style.zoom='50%'")
      .perform(async () => {
        const tableData = await browser.loggerDbGetTableContent('table');
        assert.match(tableData[1][3], /^Test message 3/);
        assert.match(tableData[2][3], /^Test message 2/);
        assert.match(tableData[3][3], /^Test message 1/);
      });

    browser.drupalRelativeURL(
      '/admin/structure/views/view/logger_db_logs/edit/page',
    );

    // Check the numeric filter with equals operator.
    browser.perform(async () => {
      utils.setViewsInfo('logger_db_logs', 'page');
      utils.addViewsField(browser, {
        pluginName: 'log_value',
        valuePath: 'metadata.number_increment_2',
      });

      utils.addViewsField(browser, {
        pluginName: 'log_value',
        valuePath: '$.metadata.nested_values.key3',
      });

      utils.addViewsField(browser, {
        fieldType: 'filter',
        pluginName: 'log_value_numeric',
        valuePath: '$.metadata.number_increment_1',
        value: '2',
        operator: '=',
      });

      const tableData = await utils.executeAndGetTable(browser);
      assert.strictEqual('102', tableData[1][5]);
    });

    // Check the numeric filter with "less than" operator.
    browser.perform(async () => {
      utils.editViewsField(browser, {
        fieldType: 'filter',
        fieldId: 'log_value_numeric',
        valuePath: 'metadata.number_increment_1',
        value: '2',
        operator: '<',
      });

      const tableData = await utils.executeAndGetTable(browser);
      assert.strictEqual('101', tableData[1][5]);
    });

    // Check the numeric filter with "greater than" operator.
    browser.perform(async () => {
      utils.editViewsField(browser, {
        fieldType: 'filter',
        fieldId: 'log_value_numeric',
        valuePath: 'metadata.number_increment_1',
        value: '2',
        operator: '>=',
      });

      const tableData = await utils.executeAndGetTable(browser);
      assert.strictEqual(3, tableData.length);
      assert.strictEqual('103', tableData[1][5]);
      assert.strictEqual('102', tableData[2][5]);
    });

    // Check the string filter with "contains" operator.
    browser.perform(async () => {
      utils.addViewsField(browser, {
        fieldType: 'filter',
        pluginName: 'log_value_string',
        valuePath: 'metadata.nested_values.key3',
        value: 'message 3 key3',
        operator: 'contains',
      });
      const tableData = await utils.executeAndGetTable(browser);
      assert.strictEqual(2, tableData.length);
      assert.strictEqual('103', tableData[1][5]);
    });

    // Check the string filter with " not contains" operator.
    browser.perform(async () => {
      utils.editViewsField(browser, {
        fieldType: 'filter',
        fieldId: 'log_value_string',
        valuePath: '$.metadata.nested_values.key3',
        value: 'message 3 key3',
        operator: 'not',
      });
      const tableData = await utils.executeAndGetTable(browser);
      assert.strictEqual(2, tableData.length);
      assert.strictEqual('102', tableData[1][5]);
    });

    browser
      .click('[data-drupal-selector="edit-actions-submit"]')
      .waitForElementPresent('body')
      .assert.textContains('[data-drupal-messages]', 'has been saved');
  },
};
