<?php

namespace Drupal\logger_db\Plugin\views\filter;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\logger_db\Plugin\views\JsonValuePathFunctionsTrait;
use Drupal\views\Attribute\ViewsFilter;
use Drupal\views\Plugin\views\filter\NumericFilter;

/**
 * Exposes log channels to views module.
 */
#[ViewsFilter('logger_db_log_value_numeric')]
class LoggerDbLogValueNumericFilter extends NumericFilter implements ContainerFactoryPluginInterface {

  use JsonValuePathFunctionsTrait;

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->ensureMyTable();
    $value = $this->value['value'];
    if (isset($value)) {
      /** @var \Drupal\views\Plugin\views\query\Sql $query */
      $query = $this->query;

      // Normalize and prepare the JSON path.
      $jsonPath = $this->normalizeJsonPath($this->options['value_path']);
      $pathPlaceholder = $query->placeholder('json_path');

      // Build the JSON expression with the path placeholder.
      $valueExpression = $this->getJsonExpression($this->tableAlias . '.data', $pathPlaceholder, self::$valueFormatNumeric);

      // Generate a unique placeholder for the filter value.
      $valuePlaceholder = $query->placeholder($this->field . '_value');

      // Build the complete expression.
      $expression = "$valueExpression $this->operator $valuePlaceholder";

      $query->addWhereExpression(
        $this->options['group'],
        $expression,
        [
          $pathPlaceholder => $jsonPath,
          $valuePlaceholder => $value,
        ],
      );
    }
  }

}
