const assert = require('assert');
const {
  basePath,
  setViewsInfo,
  addViewsField,
  deleteViewsField,
  executeAndGetTable,
} = require('../Lib/ViewsUtils');

module.exports = {
  '@tags': ['logger_db', 'logger_db-matrix'],
  before(browser) {
    browser.drupalInstall({
      installProfile: 'logger_db_test_profile',
    });
  },
  after(browser) {
    browser.drupalUninstall();
  },
  'Views Aggregation': async (browser) => {
    // Drupal 10.x has an issue with Views preview is opened in on a separate
    // after adding a field, if the Claro admin theme is not enabled.
    // But for Drupal 11.x it works fine.
    // @todo Remove this when dropping Drupal 10.x support.
    browser.drupalEnableTheme('claro', true);
    browser.window
      // To include more details into the screenshot. Should be set after
      // visiting the first page on the domain, not before.
      .setSize(1920, 2500)
      .drupalRelativeURL('/')
      .execute("document.body.style.zoom='50%'")
      .thLogin('admin')
      .drupalRelativeURL('/admin/structure/views/add')

      // Create a new view.
      .setValue(
        'input[data-drupal-selector="edit-label"]',
        'Logger DB Test Aggregation',
      )
      .perform(() => {
        browser
          .element('input[data-drupal-selector="edit-page-create"]')
          .check();
      })
      .thPerformAndWaitForReRender(() => {
        browser.click('option[value="table"]');
      }, 'fieldset[data-drupal-selector="edit-page-style"]')
      .thPerformAndWaitForReRender(() => {
        browser.click('option[value="standard:logger_logs"]');
      }, 'fieldset[data-drupal-selector="edit-show"]')
      .click('input[data-drupal-selector="edit-submit"]')

      // Add some fields.
      .perform(() => {
        setViewsInfo('logger_db_test_aggregation', 'page_1');
        // browser.pause();
        addViewsField(browser, {
          fieldType: 'field',
          pluginName: 'time',
          values: {
            date_format: 'Y-m-d H',
          },
        });
        deleteViewsField(browser, {
          fieldId: 'message',
        });
        addViewsField(browser, {
          pluginName: 'channel',
        });
        addViewsField(browser, {
          pluginName: 'severity',
        });
        addViewsField(browser, {
          fieldType: 'filter',
          pluginName: 'channel',
          perform: () => {
            browser
              .click(
                '[data-drupal-selector="edit-options-value-logger-db-test"]',
              )
              .click('[data-drupal-selector="edit-options-value-system"]');
          },
        });
        addViewsField(browser, {
          pluginName: 'log_value',
          valuePath: 'metadata.number_increment_1',
          perform: () => {
            browser.click('[name="options[value_format]"][value="NUMERIC"]');
          },
        });
        addViewsField(browser, {
          pluginName: 'log_value',
          valuePath: 'metadata.number_increment_2',
          perform: () => {
            browser.click('[name="options[value_format]"][value="NUMERIC"]');
          },
        });
      })

      // Enable aggregation.
      .click('details.views-display-column')
      .click(
        `a[href="${basePath}/admin/structure/views/nojs/display/logger_db_test_aggregation/page_1/group_by"]`,
      )
      .click('input[data-drupal-selector="edit-group-by"]')
      .click('.ui-dialog-buttonset .button--primary')

      .click(
        `a[href="${basePath}/admin/structure/views/nojs/handler-group/logger_db_test_aggregation/page_1/field/log_value"]`,
      )
      .click('option[value="json_value_sum"]')
      .click('.ui-dialog-buttonset .button--primary')

      .click(
        `a[href="${basePath}/admin/structure/views/nojs/handler-group/logger_db_test_aggregation/page_1/field/log_value_1"]`,
      )
      .click('option[value="json_value_min"]')
      .click('.ui-dialog-buttonset .button--primary')

      .click(
        `a[href="${basePath}/admin/structure/views/nojs/handler-group/logger_db_test_aggregation/page_1/field/severity"]`,
      )
      .click('option[value="count_distinct"]')
      .click('.ui-dialog-buttonset .button--primary')

      // Check the table.
      .perform(async () => {
        const tableData = await executeAndGetTable(browser);
        assert.match(tableData[1][0], /\d\d\d\d-\d\d-\d\d \d\d/);
        assert.equal(tableData[1][1], 'logger_db_test');
        assert.equal(tableData[1][2], '2');
        assert.equal(tableData[1][3], '6');
        assert.equal(tableData[1][4], '101');

        assert.match(tableData[2][0], /\d\d\d\d-\d\d-\d\d \d\d/);
        assert.equal(tableData[2][1], 'system');
        assert.equal(tableData[2][2], '1');
        assert.equal(tableData[2][3], '');
        assert.equal(tableData[2][4], '');
      });
  },
};
