<?php

namespace Drupal\logger_db\Plugin\views\field;

/**
 * Provides a field handler that renders a log severity.
 */
trait LoggerDbValueJsonQueryTrait {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $this->ensureMyTable();

    /** @var \Drupal\views\Plugin\views\query\Sql $query */
    $query = $this->query;

    // Normalize and prepare the JSON path.
    $jsonPath = $this->normalizeJsonPath($this->options['value_path']);
    $pathPlaceholder = $query->placeholder('json_path');

    // Build the JSON expression with the path placeholder.
    $expression = $this->getJsonExpression($this->tableAlias . '.data', $pathPlaceholder);

    $params = [
      'placeholders' => [
        $pathPlaceholder => $jsonPath,
      ],
    ];

    if (
      $this->options['group_type']
      && $this->options['group_type'] !== 'group'
    ) {
      $params['function'] = $this->options['group_type'];
    }

    $this->field_alias = $query->addField(NULL, $expression, $this->field, $params);
  }

}
