<?php

namespace Drupal\logger_entity\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\Attribute\ContentEntityType;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Entity\ContentEntityDeleteForm;
use Drupal\entity\Menu\EntityCollectionLocalActionProvider;
use Drupal\entity\EntityPermissionProvider;
use Drupal\Core\Entity\Routing\DefaultHtmlRouteProvider;
use Drupal\views\EntityViewsData;

/**
 * Defines the Logger Entry entity.
 *
 * @ingroup logger_entity
 */
#[ContentEntityType(
  id: 'logger_entry',
  label: new TranslatableMarkup('Logger Entry'),
  base_table: 'logger_entry',
  entity_keys: [
    'uuid' => 'uuid',
    'id' => 'id',
    'label' => 'message',
  ],
  handlers: [
    'access' => EntityAccessControlHandler::class,
    'form' => [
      'add' => ContentEntityForm::class,
      'edit' => ContentEntityForm::class,
      'delete' => ContentEntityDeleteForm::class,
    ],
    'local_action_provider' => [
      'collection' => EntityCollectionLocalActionProvider::class,
    ],
    'permission_provider' => EntityPermissionProvider::class,
    'route_provider' => [
      'default' => DefaultHtmlRouteProvider::class,
    ],
    'views_data' => EntityViewsData::class,
  ],
  translatable: FALSE,
  admin_permission: 'administer logger entries',
  links: [
    'canonical' => '/admin/reports/log-entries/{logger_entry}',
  ],
)]
class LoggerEntry extends ContentEntityBase {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['time'] = BaseFieldDefinition::create('timestamp')
      ->setLabel(t('Logged time'))
      ->setDescription(t('The time the log entry was recorded.'))
      ->setRequired(TRUE);

    $fields['severity'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Severity'))
      ->setDescription(t('Numeric severity level.'))
      ->setRequired(TRUE)
      ->setSettings(['size' => 'tiny']);

    $fields['channel'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Channel'))
      ->setDescription(t('Logging channel identifier.'))
      ->setRequired(TRUE)
      ->setSettings(['max_length' => 128]);

    $fields['message'] = BaseFieldDefinition::create('string_long')
      ->setLabel(t('Message'))
      ->setDescription(t('Log message.'))
      ->setRequired(TRUE);

    $fields['data'] = BaseFieldDefinition::create('json_native')
      ->setLabel(t('Context data'))
      ->setDescription(t('Additional context for the log entry.'))
      ->setRequired(FALSE);

    return $fields;
  }

}
