<?php

namespace Drupal\login_alert\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Session\SessionManager;

/**
 * LoginAlertBlockController Controller.
 */
class LoginAlertBlockController extends ControllerBase {

  protected $serviceSession;

  /**
   * {@inheritdoc}
   */
  public function __construct(SessionManager $sessionManager) {
    $this->serviceSession = $sessionManager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('session_manager')
    );
  }

  /**
   * Destroy all session for the specific user.
   *
   * @param string $hash
   *   Encoded string for userid.
   *
   * @return array
   *   A RedirectResponse object to redirect user at login page.
   */
  public function loginAlertBlock($hash) {
    $hash_decode = base64_decode($hash);
    $hash_arr = (explode("-", $hash_decode));
    $uid = $hash_arr[4];
    $this->serviceSession->delete($uid);
    return $this->redirect('<front>');
  }

}
