// Shorthand for $(document).ready(). See http://api.jquery.com/ready for further details.
(function($) {
  // Prevent colorbox from interfering
	// https://github.com/jackmoore/colorbox/issues/389
  if($.colorbox) {
    $.colorbox.settings.trapFocus = false;
    $.colorbox.remove();
  }

	// Admin form helper functionality
	$("#login-by-ip-assigned-users .delete-user").click(function(event) {
    return confirm("Are you sure you want to delete this user IP?");
  });

	var basePath = Drupal.settings.basePath;

	// Use debugging when it's turned on
	var debug = Drupal.settings.login_by_ip.debug;
				
	// Make sure only anonymous sessions get to use Login by IP
	var start_login = verify_login();
	if(start_login) {

		// Step 1 - Continue only if Login by IP is enabled
		var is_enabled = (Drupal.settings.login_by_ip.enabled == 1) ? true : false;
		if(is_enabled) {
			debug ? console.log("Is enabled? ", is_enabled) : '';

			// Step 2 - Get the IP for the current visitor
			$.get("https://api.ipify.org", function(data) {
				debug ? console.log("Client IP: ", data) : '';
				if(data) {

					// Step 3 - Check if a user is assigned to the current client IP
					$.get(basePath + 'login_by_ip_match_user/' + data, function(user_data) {
						// If a valid account was found, start the login sequence
						debug ? console.log("Matched user: ", user_data) : '';
						if(user_data.account) {
							// Since a valid account was found, set the right cookie to 'allowed' 
							// so that this user can login in the future
							$.cookie("Drupal.visitor.login_by_ip_user_allowed", 'allowed');
							
							// We can't use slashes (/) in the URL, encode them.
							// They will be decoded later in the login_by_ip_enabled_path() function in the module.
							var currentPath = window.location.pathname.replace(/^\/|\/$/g, '');
							currentPath = currentPath.replace('/', '-=-=-');
							debug ? console.log("Current path: ", currentPath) : '';

							// Step 4 - Is it enabled for the current page?
							$.get(basePath + 'login_by_ip_enabled_path/' + currentPath + '/' + user_data.uid, function(enabled_path) {
								debug ? console.log("Enabled path: ", enabled_path) : '';
								if(enabled_path.path) {
									dialogdiv = $('<div id="ip-login-display"><div class="login-by-ip-logo"><center><img src="' + enabled_path.logo + '" /></center></div></div>');
									btns = {};

									dialogdiv.dialog({
										modal: true, autoOpen: false, closeOnEscape: false, resizable: false, draggable: false, autoresize: true, namespace: 'jquery_ui_dialog_default_ns', title: "Login by IP", buttons: btns, minWidth: 300, maxWidth: 500, maxHeight: 700,
										show: {
											effect: 'fadeIn',
											duration: 500
										},
										close: function(event, ui) {
											// Properly clean up a JQuery Dialog box to prevent memory leaks
											$(this).dialog("destroy");
										},
										open: function(event, ui) {
											// Do not allow the option to close the modal window
											$(".ui-dialog-titlebar-close").hide();
											// Start adding relevant text to the modal box
											$('#ip-login-display').append("<p>Your IP (<b>" + data + "</b>) was found to be linked to account <b>" + user_data.user + "</b></p><p>Please wait while we log you in...</p>");

											// Step 5 - Login the user
											$.get(basePath + 'login_by_ip_user_open_session/' + user_data.uid, function(logged_in) {
												debug ? console.log("Logged in: ", logged_in) : '';
												if(logged_in) {
													// Skip the cache and reload the current page from the server
													window.location.reload(true);
												}
											});
										}
									});
									dialogdiv.dialog("open");
								} // current_path
							});
						} else {
							$.cookie("Drupal.visitor.login_by_ip_user_allowed", 'forbidden');
						}
					});
				}
			});
		}
	} // start_login

	function verify_login() {
		var login_by_ip_session = Drupal.settings.login_by_ip.session;
		debug ? console.log('Existing session: ', login_by_ip_session) : '';
		// If there is an open session, stop execution
		if(login_by_ip_session) {
			return false;
		}
		
		// Check if the current visitor has the IP connected to an account
		if(!!$.cookie("Drupal.visitor.login_by_ip_user_allowed")) {
			// Have cookie, get it
			var cookie_allowed = $.cookie("Drupal.visitor.login_by_ip_user_allowed");
			if(cookie_allowed == 'allowed') {
				var user_allowed = true;
			} else {
				var user_allowed = false;
			}
		} else {
			// No cookie, set it
			$.cookie("Drupal.visitor.login_by_ip_user_allowed", 'allowed');
			var user_allowed = true;
		}
		debug ? console.log('User allowed: ', user_allowed) : '';

		// Check the latest timestamp
		var login_by_ip_timestamp = Drupal.settings.login_by_ip.timestamp;
		debug ? console.log('login_by_ip_timestamp: ', login_by_ip_timestamp) : '';
		if(!!$.cookie("Drupal.visitor.login_by_ip_timestamp")) {
			// Have cookie, get it
			var cookie_timestamp = $.cookie("Drupal.visitor.login_by_ip_timestamp");
			if(login_by_ip_timestamp > cookie_timestamp) {
				$.cookie("Drupal.visitor.login_by_ip_timestamp", login_by_ip_timestamp);
				var login_enabled = true;
			} else {
				var login_enabled = false;
			}
		} else {
			// No cookie, set it.
			// When the module first gets installed, the cookie is set to 0 and login_enabled is false (there are no users
			// set up with Login by IP so, no need to even start searching for users.
			if(login_by_ip_timestamp) {
				$.cookie("Drupal.visitor.login_by_ip_timestamp", login_by_ip_timestamp);
				var login_enabled = false;
			} else {
				$.cookie("Drupal.visitor.login_by_ip_timestamp", login_by_ip_timestamp);
				var login_enabled = true;
			}
		}
		debug ? console.log('Login enabled: ', login_enabled) : '';

		if(user_allowed || login_enabled) {
			var start_login = true;
		} else {
			var start_login = false;
		}
		debug ? console.log('Start login: ', start_login) : '';

		return start_login;
	}
})(jQuery);
