<?php

/**
 * @file
 * Administration functions for Login Custom Field module.
 */

/**
 * Main settings page.
 */
 function lcf_main_settings(){

   $form['login'] = array(
     '#type' => 'fieldset',
     '#title' => t('Log in'),
   );

   $form['login']['login_custom_field_status'] = array(
     '#type' => 'radios',
     '#title' => t('Enable custom field login functionality'),
     '#description' => t('In some cases you should clear cache since the login form cached for visitors.'),
     '#default_value' => variable_get('login_custom_field_status', 0),
     '#options' => array(0 => t('Disabled'), 1 => t('Enabled')),
     '#required' => TRUE,
   );

   $user_object_fields = lcf_get_user_object_fields();
   $form ['login']['login_custom_field_by_field'] = array(
     '#type' => 'select',
     '#title' => t('Allow login using this field'),
     '#description' => t('You should make sure the selected field is unique.'),
     '#options' => $user_object_fields,
     '#default_value' => variable_get('login_custom_field_by_field'),
     '#required' => TRUE,
   );

   return system_settings_form($form);
 }
