((Drupal) => {

  Drupal.behaviors.keyDisplayInputChange = {
    
    attach(context) {
      
      once('keyDisplayInputChange', 'input[name="keyDisplay"]', context).forEach(function (element) {
        
        const hiddenInput = context.querySelector('input[name="keyCode"]');
        
        const keyOutput = context.querySelector('.js-form-item-keydisplay .output .key .value');

        keyOutput.textContent = String.fromCharCode(hiddenInput.value);

        //// Shift[left|right], Ctrl[left|right], Alt[left|right], MetaLeft, MetaRight
        const ignoreCodes = [16, 17, 18, 91, 93];
        
        element.addEventListener('keyup', (event) => {
          if (
            !ignoreCodes.includes(event.keyCode)
          ) {
            hiddenInput.value = event.keyCode;

            keyOutput.textContent = String.fromCharCode(event.keyCode);
            
            const keyCodeOutput = context.querySelector('.form-item--keydisplay .output .keyCode .value');
            keyCodeOutput.textContent = event.keyCode;
            
            element.value = String.fromCharCode(event.keyCode);
            element.select();
          }
        });

        element.addEventListener('click', (event) => {
          element.select();
        });

      });
      
    }
    
  };
  
})(Drupal);
