(function (Drupal, once) {
  Drupal.behaviors.modalExample = {
    attach: function (context, settings) {
      once('modal-example', '.use-modal-example', context).forEach(function (el) {
        el.addEventListener('click', function (e) {
          e.preventDefault();

          const modalContent = document.createElement('div');
          modalContent.innerHTML = '<div>This is an example of the <em>modal</em> dialog type.</div>';

          const cancelBtn = document.createElement('button');
          cancelBtn.textContent = 'Cancel';
          cancelBtn.className = 'button button--primary dialog-cancel';

          modalContent.appendChild(cancelBtn);

          Drupal.dialog(modalContent, {
            title: 'Modal',
            dialogClass: 'modal-example-dialog',
            modal: true,
            resizable: false
          }).showModal();
        });
      });
    }
  };
})(Drupal, once);