<?php

namespace Drupal\login_dialog_hotkey\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\Core\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Provides an example controller for demonstrating the off-canvas dialog type.
 */
class OffcanvasExampleController extends ControllerBase {

  /**
   * The form builder.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected $formBuilder;

  /**
   * Constructs a new OffcanvasExampleController.
   *
   * @param \Drupal\Core\Form\FormBuilderInterface $form_builder
   *   The form builder service.
   */
  public function __construct(FormBuilderInterface $form_builder) {
    $this->formBuilder = $form_builder;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('form_builder')
    );
  }

  /**
   * Returns a render array for the off-canvas dialog example.
   *
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The current request object.
   *
   * @return array
   *   A render array for the off-canvas dialog.
   */
  public function offcanvas(Request $request) {
    $form = $this->formBuilder->getForm('Drupal\login_dialog_hotkey\Form\OffcanvasExampleForm');
    $form['#title'] = $this->t('Off-canvas');
    return $form;
  }

}
