<?php

namespace Drupal\login_flow\Plugin;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\user\UserInterface;

/**
 * Provides a base implementation for an Login Flow plugin.
 *
 * @see \Drupal\login_flow\Attribute\LoginFlow
 * @see \Drupal\login_flow\LoginFlowManager
 * @see \Drupal\login_flow\LoginFlowInterface
 * @see plugin_api
 */
abstract class LoginFlowBase extends PluginBase implements ContainerFactoryPluginInterface {

  use StringTranslationTrait;

  /**
   * The user ID to be logged in.
   */
  protected int $userId;

  /**
   * {@inheritdoc}
   */
  public function getConfiguration() {
    return $this->configuration + $this->defaultConfiguration();
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigurationSummary() {
    return 'Plugin not configured';
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function setUserAccountId($user_id) {
    $this->userId = $user_id;
  }

  /**
   * {@inheritdoc}
   */
  public function getUserAccountId() {
    return $this->userId;
  }

  /**
   * {@inheritdoc}
   */
  public function isApplicable(UserInterface $account, FormStateInterface $form_state) {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function getFormElements() {
    return [];
  }

}
