<?php

namespace Drupal\Tests\login_flow\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test setup for the Login Flow module.
 *
 * @group login_flow
 */
abstract class LoginFlowTestBase extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'login_flow',
  ];

  /**
   * An admin user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $adminUser;

  /**
   * Default theme for testing.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * Set to TRUE to strict check all configuration saved.
   *
   * @var bool
   */
  protected $strictConfigSchema = TRUE;

  /**
   * Performs the basic setup tasks.
   */
  public function setUp(): void {
    parent::setUp();
    // Creates role and user.
    $permissions = [
      'administer site configuration',
    ];
    $this->adminUser = $this->drupalCreateUser($permissions);
  }

  /**
   * Enables and configures the email only plugin.
   */
  protected function enableEmailOnlyPlugin() {
    $plugins = [
      [
        'plugin_id' => 'login_flow_email',
        'enabled' => TRUE,
        'weight' => 0,
      ],
      [
        'plugin_id' => 'login_flow_password',
        'enabled' => TRUE,
        'weight' => 10,
      ],
    ];

    $this->config('login_flow.settings')
      ->set('plugins', $plugins)
      ->set('username_title', 'Username or email address')
      ->set('username_description', 'This is the test description')
      ->save();

    $this->config('login_flow.plugin.login_flow_email')
      ->set('configuration', [
        'roles' => [],
        'domains' => [
          'example.com',
        ],
      ])
      ->save();
  }

}
