<?php

namespace Drupal\Tests\login_flow\Functional;

use Drupal\Core\Url;

/**
 * Test the changes to the login form.
 *
 * @group login_flow
 */
class LoginFlowLoginFormTest extends LoginFlowTestBase {

  /**
   * An example.com user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $exampleUser;

  /**
   * Performs the basic setup tasks.
   */
  public function setUp(): void {
    parent::setUp();
    $this->exampleUser = $this->drupalCreateUser([], 'john', FALSE, ['mail' => 'john@example.com']);
  }

  /**
   * Test login form in default mode (should be the same).
   */
  public function testDefaultLoginForm() {
    $this->drupalGet(Url::fromRoute('user.login'));
    $this->assertSession()->pageTextContains('Username or email address');
    $this->assertSession()->pageTextContains('Password');
    $this->assertSession()->fieldExists('edit-pass');
    $this->assertSession()->elementAttributeContains('css', '#edit-submit', 'value', 'Log in');
  }

  /**
   * Test login form changes.
   */
  public function testModifiedLoginForm() {
    $this->enableEmailOnlyPlugin();
    $this->resetAll();
    // After enabling the email only plugin, the password field should be gone.
    $this->drupalGet(Url::fromRoute('user.login'));
    $this->assertSession()->fieldNotExists('edit-pass');
    $this->assertSession()->elementAttributeContains('css', '#edit-submit', 'value', 'Next >');

    // Try and login as user with email only.
    $page = $this->getSession()->getPage();
    $page->fillField('name', 'john@example.com');
    $page->pressButton('Next >');

    $this->assertSession()->statusMessageContains("If john@example.com is a valid account, an email was sent with a one-time login link.");
  }

}
